Class Regularized Optimal Transport
======

Python toolbox for reproducing the simulation in the paper [Domain adaptation with regularized optimal
transport](http://remi.flamary.com/biblio/courty2014domain.pdf).

### Features

* Optimal Tranport Solvers
    * LP solver for classic OT
    * Sinkhorn OT
    * Class regularised OT ith non-convex group 

### Python dependencies

* Numpy, Matplotlib, Scipy
* cvxopt


### Installation

* **transport.py** python module containing all the optimal transport solvers.

Entry points:

* **example_visu_tranport.py** script illustrating the different OT approaches
* **run_vision_dataset** loop for comparaing domain adaptation on the computer vision dataset

### Aknowlegments

- [Marco Cuturi](http://www.iip.ist.i.kyoto-u.ac.jp/member/cuturi/) for providing us with the matlab version of Sinkhorn.

### Contacts

- [Rémi Flamary](http://remi.flamary.com/)
- [Nicolas Courty](http://people.irisa.fr/Nicolas.Courty/)


